//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "stereo.h"
#include "fkostka.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
 odczytaj_parametry();
}
//---------------------------------------------------------------------------
// Odczytaj parametry
void TForm1 :: odczytaj_parametry( void)
{
 try
 {
    sp = (StylPatrzenia)RadioGroup1 -> ItemIndex;
    if( sp == Anaglif)
    {
        Lkolor = clRed;
        Rkolor = clAqua;
    }
    else
    {
        Lkolor = Rkolor = clBlack;
    }
    baza = (double)TrackBar1 -> Position / 100.;
    obserwator.x = (double)TrackBar2 -> Position / 10.;
    obserwator.y = (double)TrackBar3 -> Position / 10.;
    obserwator.z = (double)TrackBar4 -> Position / 10.;
    ogniskowa = (double)TrackBar5 -> Position/100.;
 }
 catch(...)
 {
 }
}
//---------------------------------------------------------------------------
//  Wykrelenie kostki, rozpitej na podanych wierzchokach
void __fastcall TForm1::PaintBox1Paint(TObject *Sender)
{
 TStereo s( obserwator,         //pozycja obserwatora
    0, 0, PaintBox1 -> Width, PaintBox1 -> Height, //okienko ekranowe
    baza,                       //odlego midzy oczami
    PaintBox1 -> Canvas,        //aparat graficzny
    sp,                         //styl projekcji stereo
    ogniskowa);                 //odlego oka od paszczyzny obrazowej

 TPunkt p1(1,1,-1), p2(-1,1,-1), p3(-1,-1,-1), p4(1,-1,-1),
        p5(1,1,1),  p6(-1,1,1),  p7(-1,-1,1),  p8(1,-1,1);

 s.linia_stereo( p1, p2, Lkolor, Rkolor);
 s.linia_stereo( p2, p3, Lkolor, Rkolor);
 s.linia_stereo( p3, p4, Lkolor, Rkolor);
 s.linia_stereo( p4, p1, Lkolor, Rkolor);

 s.linia_stereo( p5, p6, Lkolor, Rkolor);
 s.linia_stereo( p6, p7, Lkolor, Rkolor);
 s.linia_stereo( p7, p8, Lkolor, Rkolor);
 s.linia_stereo( p8, p5, Lkolor, Rkolor);

 s.linia_stereo( p1, p5, Lkolor, Rkolor);
 s.linia_stereo( p2, p6, Lkolor, Rkolor);
 s.linia_stereo( p3, p7, Lkolor, Rkolor);
 s.linia_stereo( p4, p8, Lkolor, Rkolor);

/* TPunkt p0(0,0,0), p1(2,0,0), p2(-2,0,0), p3(0,2,0), p4(0,-2,0),p5(0,0,2),p6(0,0,-2),
   p7(2,2,1),  p8(2,2,0),
   p9(2.3,1.7,1), p10(1.7,2.3,1),
   p11(2.3,1.7,0), p12(1.7,2.3,0);
 Lkolor = Rkolor = clSilver;
 s.linia_stereo( p1, p2, Lkolor, Rkolor);
 s.linia_stereo( p3, p4, Lkolor, Rkolor);
 s.linia_stereo( p5, p6, Lkolor, Rkolor);

 s.linia_stereo( p0, p7, Lkolor, Rkolor);
 s.linia_stereo( p0, p8, Lkolor, Rkolor);

 s.linia_stereo( p9, p10, Lkolor, Rkolor);
 s.linia_stereo( p11, p12, Lkolor, Rkolor);
*/
}
//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
 odczytaj_parametry();
 PaintBox1 -> Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_ESCAPE)
    Close();
}
//---------------------------------------------------------------------------

